<?php
/* Smarty version 4.5.5, created on 2025-02-11 14:03:09
  from '/Users/nikolaimv/Sites/ideal-color.loc/admin/templates/views/feedbacks/script.tpl' */

/* @var Smarty_Internal_Template $_smarty_tpl */
if ($_smarty_tpl->_decodeProperties($_smarty_tpl, array (
  'version' => '4.5.5',
  'unifunc' => 'content_67ab124d6e5478_83959491',
  'has_nocache_code' => false,
  'file_dependency' => 
  array (
    '92e72992a8440781f2c6147c18b53cc784e9c74d' => 
    array (
      0 => '/Users/nikolaimv/Sites/ideal-color.loc/admin/templates/views/feedbacks/script.tpl',
      1 => 1734956088,
      2 => 'file',
    ),
  ),
  'includes' => 
  array (
  ),
),false)) {
function content_67ab124d6e5478_83959491 (Smarty_Internal_Template $_smarty_tpl) {
echo '<script'; ?>
>
    document.addEventListener('DOMContentLoaded', () => {
        // Инициализация select2 через jQuery
        const selectFieldTypes = $('#fieldTypes');
        const selectInputTypes = $('#inputTypes');

        // Кэширование основных DOM-элементов
        const domElements = {
            options: document.getElementById('block_options'),
            groupPosition: document.querySelector('.group_position'),
            tableBody: document.querySelector('.table_options tbody'),
            buttonTypes: document.querySelector('.button-types'),
            inputTypes: document.querySelector('.input-types'),
            inputText: document.querySelector('.input-text'),
            inputFile: document.querySelector('.input-file'),
            inputNumber: document.querySelector('.input-number'),
            inputHidden: document.querySelectorAll('.input-hidden'),
            maxlengthField: document.querySelector('#maxlength'),
            readonlyCheckbox: document.querySelector('#readonly')
        };

        // Проверка доступности всех необходимых DOM-элементов
        if (!selectFieldTypes.length || !selectInputTypes.length) {
            console.error('Не удалось найти select для типов полей или input. Проверьте DOM.');
            return;
        }

        if (!Object.values(domElements).every(el => el !== null && el !== undefined)) {
            console.error('Не удалось найти один или несколько важных DOM элементов.');
            return;
        }

        // Деструктуризация для удобства работы с кэшированными элементами
        const {
            options,
            groupPosition,
            tableBody,
            buttonTypes,
            inputTypes,
            inputText,
            inputFile,
            inputNumber,
            inputHidden,
            maxlengthField,
            readonlyCheckbox
        } = domElements;

        // Универсальная утилита: управление классу видимости
        const setVisibility = (element, isVisible) => {
            if (!element) return;
            const showClass = 'show';
            if (element instanceof NodeList) {
                element.forEach(el => el.classList.toggle(showClass, Boolean(isVisible)));
            } else {
                element.classList.toggle(showClass, Boolean(isVisible));
            }
        };

        // Очистка всех строк внутри таблицы
        const clearTableBody = (table) => {
            table.innerHTML = ''; // Быстрее, чем удаление через цикл
        };

        // Логика: скрытие всех блоков для полей
        const hideFieldBlocks = () => {
            [options, groupPosition, buttonTypes, inputTypes].forEach(el => setVisibility(el, false));
        };

        // Логика: скрытие всех блоков для input
        const hideInputBlocks = () => {
            [inputText, inputFile, inputNumber, inputHidden].forEach(el => setVisibility(el, false));
        };

        // Сброс значения selectInputTypes
        const clearSelectInputTypes = () => {
            selectInputTypes.val(null).trigger('change'); // Сбрасывает значение и обновляет select2
        };

        // Обработчик: изменения типа поля
        const handleFieldChange = (value) => {
            console.log(`Выбрано значение поля selectFieldTypes: ` + value);
            hideFieldBlocks();
            // Выбираем действия в зависимости от значения
            switch (value) {
                case 'I': // Input type
                    setVisibility(inputTypes, true);
                    clearTableBody(tableBody);
                    break;

                case 'B': // Button
                    clearTableBody(tableBody);
                    setVisibility(buttonTypes, true);
                    clearSelectInputTypes(); // Сброс значения selectInputTypes
                    break;

                case 'T': // Textarea
                    clearTableBody(tableBody);
                    clearSelectInputTypes(); // Сброс значения selectInputTypes
                    break;

                case 'R': // Radio type
                    setVisibility(groupPosition, true);
                    setVisibility(options, true);
                    clearSelectInputTypes(); // Сброс значения selectInputTypes
                    break;

                case 'S': // Select type
                case 'C': // Checkbox type
                    setVisibility(options, true);
                    clearSelectInputTypes(); // Сброс значения selectInputTypes
                    break;

                default: // По умолчанию
                    setVisibility(options, true);
                    setVisibility(inputText, false);
            }
        };

        // Обработчик: изменения типа input
        const handleInputChange = (inputValue) => {
            console.log(`Выбрано значение input: ` + inputValue);
            hideInputBlocks();
            setVisibility(inputHidden, true);
            const validTextTypes = ['text', 'tel', 'email'];

            if (validTextTypes.includes(inputValue)) {
                setVisibility(inputText, true);
            } else if (inputValue === 'file') {
                setVisibility(inputFile, true);
            } else if (inputValue === 'number') {
                setVisibility(inputNumber, true);
            } else if (inputValue === 'hidden') {
                setVisibility(inputHidden, false); // Показать скрытые input
            } else {
                // Сброс неизвестных типов input
                if (maxlengthField) maxlengthField.value = ''; // Очистка maxlength
                if (readonlyCheckbox) readonlyCheckbox.checked = false; // Сброс checkbox
            }
        };

        // Утилита: инициализация слушателя изменений select
        const initSelectHandler = (select, handler) => {
            const initialValue = select.val(); // Значение по умолчанию
            if (initialValue) handler(initialValue);

            select.on('change', function () {
                handler($(this).val());
            });
        };

        // Подключение обработчиков для select полей
        initSelectHandler(selectFieldTypes, handleFieldChange);
        initSelectHandler(selectInputTypes, handleInputChange);
    });


    // document.addEventListener('DOMContentLoaded', () => {
    //     // Используем jQuery для select2 и кэшируем элементы
    //     const selectFieldTypes = $('#fieldTypes');
    //     const selectInputTypes = $('#inputTypes');
    //
    //     // Кэш основные DOM-элементов
    //     const elements = {
    //         options: document.getElementById('block_options'),
    //         groupPosition: document.querySelector('.group_position'),
    //         multipleFiles: document.querySelector('.multiple_files'),
    //         tableBody: document.querySelector('.table_options tbody'),
    //         inputTypes: document.querySelector('.input-types'),
    //         inputText: document.querySelector('.input-text'),
    //         inputNumber: document.querySelector('.input-number'),
    //         inputHidden: document.querySelectorAll('.input-hidden'),
    //     };
    //
    //     // Проверим сразу, есть ли все элементы в DOM
    //     const areElementsValid = Object.entries(elements).every(([key, el]) => {
    //         if (!el) {
    //             console.error(`Элемент ` + key + ` не найден в DOM.`);
    //             return false;
    //         }
    //         return true;
    //     });
    //     if (!areElementsValid) return;
    //
    //     // Упрощаем доступ к элементам
    //     const { options, groupPosition, multipleFiles, tableBody, inputTypes, inputText, inputNumber, inputHidden } = elements;
    //
    //     // Утилита: управление видимостью элемента
    //     const toggleVisibility = (element, condition) => {
    //         if (!element) return;
    //         if (element instanceof NodeList) {
    //             element.forEach(el => el.classList.toggle('show', !!condition)); // Для NodeList
    //         } else {
    //             element.classList.toggle('show', !!condition); // Для одиночного элемента
    //         }
    //     };
    //
    //     // Очистка всех строк внутри таблицы
    //     const clearTableRows = (table) => {
    //         while (table.firstChild) {
    //             table.removeChild(table.firstChild);
    //         }
    //     };
    //
    //     // Скрытие всех элементов для полей
    //     const hideAllFieldElements = () => {
    //         [options, groupPosition, multipleFiles, inputTypes].forEach((el) => toggleVisibility(el, false));
    //     };
    //
    //     // Скрытие всех элементов для input
    //     const hideAllInputElements = () => {
    //         [inputText, inputNumber, inputHidden].forEach((el) => toggleVisibility(el, false));
    //     };
    //
    //     // Управление отображением полей в зависимости от значения select
    //     const handleFieldValueChange = (value) => {
    //         console.log(`Выбрано значение поля: ` +  value);
    //         hideAllFieldElements();
    //
    //         // Выполняем действия на основе выбранного значения
    //         switch (value) {
    //             case 'I': // Input type
    //                 toggleVisibility(inputTypes, true);
    //                 clearTableRows(tableBody);
    //                 break;
    //
    //             case 'T': // Textarea
    //                 clearTableRows(tableBody);
    //                 break;
    //
    //             case 'F': // File type
    //                 toggleVisibility(multipleFiles, true);
    //                 clearTableRows(tableBody);
    //                 break;
    //
    //             case 'R': // Radio type
    //                 toggleVisibility(groupPosition, true);
    //                 toggleVisibility(options, true);
    //                 break;
    //
    //             default: // Default case
    //                 toggleVisibility(options, true);
    //                 break;
    //         }
    //     };
    //
    //     // Управление отображением input в зависимости от типа
    //     const handleInputValueChange = (inputValue) => {
    //         console.log(`Выбрано значение input: ` + inputValue);
    //         hideAllInputElements();
    //
    //         toggleVisibility(inputHidden, true);
    //
    //         // Список поддерживаемых типов input
    //         const validInputTypes = ['text', 'tel', 'email'];
    //
    //         if (validInputTypes.includes(inputValue)) {
    //             toggleVisibility(inputText, true);
    //         } else if (inputValue === 'number') {
    //             toggleVisibility(inputNumber, true);
    //         } else if (inputValue === 'hidden') {
    //             toggleVisibility(inputHidden, false); // Для NodeList
    //         } else {
    //             // Сбрасываем значения для неизвестных input типов
    //             const maxlength = document.querySelector('#maxlength');
    //             const readonly = document.querySelector('#readonly');
    //
    //             if (maxlength) maxlength.value = ''; // Очистка значения
    //             if (readonly) readonly.checked = false; // Сброс флажка
    //         }
    //     };
    //
    //     // Инициализация обработчиков select
    //     const initSelectChangeHandler = (select, handler) => {
    //         const currentValue = select.val?.(); // Проверяем, поддерживает ли select метод val
    //         if (currentValue) handler(currentValue);
    //
    //         select.on('change', function () {
    //             const selectedValue = $(this).val();
    //             handler(selectedValue);
    //         });
    //     };
    //
    //     // Инициализация обработчиков для поля и input
    //     initSelectChangeHandler(selectFieldTypes, handleFieldValueChange);
    //     initSelectChangeHandler(selectInputTypes, handleInputValueChange);
    // });

<?php echo '</script'; ?>
><?php }
}
